/**
 * A script for the Platypush browser extension that saves the current page URL to Wallabag.
 * Use together with the Reader Mode script https://gist.manganiello.tech/fabio/c731b57ff6b24d21a8f43fbedde3dc30 for best results.
 */


// Entry point for the script, which is executed when the user runs the
// associated action. All the logic should be encapsulated in this function.
async (app, args) => {
  // (Optional) topic for the ntfy notification
  const ntfyTopic = 'notebook-saved-links-random-suffix';

  // Get the page URL and DOM
  const url = await app.getURL();
  const dom = await app.getDOM();
  const getContent = () => {
    // Check if the current DOM has already been "distilled" by the Mercury script.
    // If that's the case, use the already distilled content as the body of the saved article.
    const simplifiedContainer = dom.querySelector('.platypush__simplified-body');
    return (simplifiedContainer || dom.querySelector('body')).innerHTML;
  };

  // Save the URL to Wallabag leveraging the Platypush API
  const title = dom.querySelector('head title')?.innerText;
  const response = await app.run({
    action: 'wallabag.save',
    args: {
      url: url,
      title: title,
      content: getContent(),
    }
  }, args.host);

  /*
  // Optional: Send a notification via ntfy
  await app.run({
    action: 'ntfy.send_message',
    args: {
      topic: ntfyTopic,
      message: response.title || title,
      title: 'URL saved to Wallabag',
      url: url,
    }
  }, args.host);
  */
}