// ==UserScript==
// @name         Wallabag UI fix
// @namespace    https://fabiomanganiello.com/
// @version      0.1
// @description  Make the Wallabag UI better.
// @author       Fabio Manganiello
// @match        https://CHANGE_ME_WITH_YOUR_WALLABAG_URL/*
// @icon
// @grant        none
// ==/UserScript==

(function() {
  'use strict';

  // Remove the footer
  const footer = document.getElementsByTagName('footer')[0];
  if (footer) {
    footer.style.display = 'none';
  }

  // Better header
  const nav = document.getElementsByTagName('nav')[0];
  if (nav) {
    const header = document.getElementsByClassName('nav-panels')[0];
    if (header) {
      header.style.background = 'white';
      header.style.color = 'black';
      [...header.querySelectorAll('a')].forEach((a) => a.style.color = 'black');
      [...document.querySelectorAll('a.card-title')].forEach((link) => { link.style.color = '#808080'; link.style.fontWeight = '500'});
    }
  }

  const content = document.getElementById('content');
  if (content) {
    content.style.background = 'white';
  }

  const articleContainer = document.getElementById('article');
  if (articleContainer) {
    articleContainer.style.boxShadow = 'none';
  }

  const article = document.getElementsByTagName('article')[0];
  if (article) {
    article.style.fontFamily = '-apple-system, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Fira Sans", "Open Sans", "Droid Sans", "Helvetica Neue", Helvetica, Arial, sans-serif';
    article.style.fontSize = '18px';
    article.style.fontWeight = 400;
    article.style.textAlign = 'justify';
    article.style.padding = '1.5em';
    article.style.lineHeight = '1.75em';
    article.style.textRendering = 'optimizeLegibility';
  }
})();