>>> from random import randint
# Number of voters
>>> N = 10_058_774
# Counter of occurrences
>>> cnt = 0
# Count how many occurrences we measure where the
# shares of votes exactly match their rounded
# representation to the first decimal digit
>>> for _ in range(N):
    # Share of votes to candidate A,
    # as a random number between 30% and 70%
... A = randint(round(0.3 * N), round(0.7 * N)) / N
    # Share of votes to candidate C (others),
    # as a random number between 1% and 10%
... C = randint(round(0.01 * N), round(0.1 * N)) / N
    # Share of votes to candidate B,
    # 100% - votes(A) - votes(C)
... B = 1 - A - C
    # Get the values of A, B and C rounded to the
    # first decimal
... A_round = round(round(A/N, 3) * N)
... B_round = round(round(B/N, 3) * N)
... C_round = round(round(C/N, 3) * N)
    # If the rounded representations of A, B and C
    # match their actual values, increase the counter
... if A == A_round and B == B_round and C == C_round:
...   cnt += 1
...
# Print the counter after >10M iterations
>>> cnt
0