#!/data/data/com.termux/files/usr/bin/sh

# This script installs some service management utilities in a Termux environment.
#
# You can download and directly run this script in a Termux environment through:
# curl -sSL https://gist.manganiello.tech/fabio/termux-services-setup/raw/HEAD/termux-services-setup.sh | sh
#
# NOTE: It requires curl and termux-services to be already installed:
# pkg update && pkg install curl termux-services

TERMUX_HOME="$HOME/.termux"
BIN_PATH="$PREFIX/bin"

# Create directory for user scripts
mkdir -p "$TERMUX_HOME/scripts"

cat <<EOF > "$TERMUX_HOME/scripts/sv-log"
#!/data/data/com.termux/files/usr/bin/bash

# sv-log script: A utility journalctl-like script to view and follow logs from
# Termux services

usage() {
    echo "Usage: \$0 [-h] [-f] [-n <lines>] <service>" >&2
    exit 1
}

lines=25

while getopts "fhn:" opt; do
    case "\${opt}" in
        f)
            follow=1
            ;;

        n)
            lines=\${OPTARG}
            (echo -n "\$lines" | grep -E '^[0-9]+$' >/dev/null) || usage
            ;;

        *)
            usage
            ;;
    esac
done

shift \$((OPTIND-1))
service="\$1"
[ -n "\$service" ] || usage

logfile="\$PREFIX/var/log/sv/\$service/current"
[ -f "\$logfile" ] || (
    echo "No logs found for service \$service" >&2
    exit 0
)

OPTS="-n -\${lines}"
[ -n "\$follow" ] && OPTS="-f \${OPTS}"
tail \$OPTS "\$logfile"
EOF

cat <<EOF > "$TERMUX_HOME/scripts/install-termux-services"
#!/data/data/com.termux/files/usr/bin/sh

# A script that supports the installation of custom Termux services
# by symlinking service directories from \$TERMUX_HOME/var/service
# to \$PREFIX/var/service and setting up log directories

TERMUX_HOME="\$HOME/.termux"

mkdir -p "\$HOME/.local/bin"
mkdir -p "\$PREFIX/var/service"
ln -sf "\$TERMUX_HOME/scripts/sv-log" "\$HOME/.local/bin"

find "\$TERMUX_HOME/var/service" -maxdepth 1 -type d | tail -n -1 | while read srv; do
    ln -sf "\$srv" "\$PREFIX/var/service"
    mkdir -p "\$PREFIX/var/log/sv/\$srv"
    ln -sf "\$PREFIX/var/log/sv/\$srv" "\$srv/log"
done
EOF

# Copy sv-log and install-termux-services to bin path
install -m 700 "$TERMUX_HOME/scripts/sv-log" "$BIN_PATH/sv-log"
install -m 700 "$TERMUX_HOME/scripts/install-termux-services" "$BIN_PATH/install-termux-services"